<?php
/**
 * Dynamic Styles Generator
 * Generates CSS based on settings.php color configuration
 */

// Include settings
require_once 'settings.php';

// Set content type to CSS
header('Content-Type: text/css');

// Get color settings from page-specific groups
$principles_colors = getSetting('PAGES.principles.principles_cards', []);
$walkers_colors = getSetting('PAGES.walkers.walkers_rows', []);

// Generate CSS for principles cards - cycle through 5 colors
if (!empty($principles_colors)) {
    // First, set default background for all principle cards
    echo ".principles-page .principle-card {\n";
    echo "    background-color: {$principles_colors[0]} !important;\n";
    echo "}\n\n";
    
    // Then apply specific colors for each position in the cycle
    foreach ($principles_colors as $index => $color) {
        $nth = $index + 1;
        echo ".principles-page .principle-card:nth-child(5n+{$nth}) {\n";
        echo "    background-color: {$color} !important;\n";
        echo "}\n\n";
    }
}

// Generate CSS for walkers table rows - cycle through 5 colors
if (!empty($walkers_colors)) {
    // First, set default background for all walkers rows
    echo ".walkers-table tbody tr {\n";
    echo "    background-color: {$walkers_colors[0]} !important;\n";
    echo "}\n\n";
    
    // Then apply specific colors for each position in the cycle
    foreach ($walkers_colors as $index => $color) {
        $nth = $index + 1;
        echo ".walkers-table tbody tr:nth-child(5n+{$nth}) td {\n";
        echo "    background-color: {$color} !important;\n";
        echo "}\n\n";
    }
}

// Override any hardcoded colors in CSS
echo "/* Override hardcoded colors */\n";
echo ".principle-card:nth-child(2n),\n";
echo ".principle-card:nth-child(3n),\n";
echo ".principle-card:nth-child(4n),\n";
echo ".principle-card:nth-child(5n) {\n";
// echo "    background: unset !important;\n";
echo "}\n\n";

// Generate CSS for per-page text colors (PAGES.* with global fallback)
$text_color_global = getSetting('COLORS.text_color_global', '#ffffff');
$text_color_principles = getSetting('PAGES.principles.text_color', $text_color_global);
$text_color_walkers = getSetting('PAGES.walkers.text_color', $text_color_global);
$text_color_signup = getSetting('PAGES.signup.text_color', $text_color_global);

echo "/* Per-page text color settings */\n";

// Principles page text colors
echo ".principles-page .principle-card .principle-title,\n";
echo ".principles-page .principle-card .principle-desc,\n";
echo ".principles-page .principle-card .principle-meta,\n";
echo ".principles-page .principle-card .principle-meta .meta-username {\n";
echo "    color: {$text_color_principles} !important;\n";
echo "}\n\n";

// Walkers page text colors
echo ".walkers-table,\n";
echo ".walkers-table th,\n";
echo ".walkers-table td,\n";
echo ".walker-username-link {\n";
echo "    color: {$text_color_walkers} !important;\n";
echo "}\n\n";

// Signup page text colors
echo ".auth-form,\n";
echo ".auth-form input,\n";
echo ".error-message {\n";
echo "    color: {$text_color_signup} !important;\n";
echo "}\n\n";

// Global fallback text colors
echo "body,\n";
echo ".container,\n";
echo ".main-content {\n";
echo "    color: {$text_color_global} !important;\n";
echo "}\n\n";

// Generate CSS for profile text color (PAGES with global fallback)
$text_color_profile = getSetting('PAGES.profile.text_color', $text_color_global);

echo "/* Profile text color settings */\n";
echo ".profile-page .principle-title,\n";
echo ".profile-page .principle-desc{\n";
echo "    color: {$text_color_profile} !important;\n";
echo "}\n\n";

// Generate CSS for prescription text color (PAGES with global fallback)
$text_color_prescription = getSetting('PAGES.prescription.text_color', $text_color_global);
echo "/* Prescription text color settings */\n";
echo ".landing-title,\n";
echo ".prescription-content,\n";
echo ".prescription-content h2,\n";
echo ".prescription-content h3,\n";
echo ".prescription-content p,\n";
echo ".prescription-content li{\n";
echo "    color: {$text_color_prescription} !important;\n";
echo "}\n\n";

// Generate CSS for navbar button colors and font size
$navbar_button_text_color = getSetting('COLORS.navbar_button_text_color', '#ffffff');
$navbar_button_bg_color = getSetting('COLORS.navbar_button_bg_color', '#007bff');
$navbar_button_font_size = getSetting('COLORS.navbar_button_font_size', '0.65rem');

echo "/* Navbar button colors and font size (prescription, principles, walkers) */\n";
echo ".nav-button {\n";
echo "    color: {$navbar_button_text_color} !important;\n";
echo "    background-color: {$navbar_button_bg_color} !important;\n";
echo "    font-size: {$navbar_button_font_size} !important;\n";
echo "}\n\n";

echo ".navbar .nav-link {\n";
echo "    color: {$navbar_button_text_color} !important;\n";
echo "    background-color: {$navbar_button_bg_color} !important;\n";
echo "    font-size: {$navbar_button_font_size} !important;\n";
echo "}\n\n";

// Generate CSS for profile and login button colors and font size
$profile_button_text_color = getSetting('COLORS.profile_button_text_color', '#ffffff');
$profile_button_bg_color = getSetting('COLORS.profile_button_bg_color', '#f9a1b0');
$profile_button_font_size = getSetting('COLORS.profile_button_font_size', '0.65rem');
$login_button_text_color = getSetting('COLORS.login_button_text_color', '#ffffff');
$login_button_bg_color = getSetting('COLORS.login_button_bg_color', '#f9a1b0');

echo "/* Profile and Login button colors and font size */\n";
echo ".nav-button.profile-btn {\n";
echo "    color: {$profile_button_text_color} !important;\n";
echo "    background-color: {$profile_button_bg_color} !important;\n";
echo "    font-size: {$profile_button_font_size} !important;\n";
echo "}\n\n";

echo ".nav-button.login-btn,\n";
echo ".auth-form .save-btn {\n";
echo "    color: {$login_button_text_color} !important;\n";
echo "    background-color: {$login_button_bg_color} !important;\n";
echo "    font-size: {$profile_button_font_size} !important;\n";
echo "}\n\n";

// Generate CSS for container/background colors
$body_background_color = getSetting('COLORS.body_background_color', '#1a1a1a');

echo "/* Container background color settings */\n";
echo "body {\n";
echo "    background-color: {$body_background_color} !important;\n";
echo "}\n\n";

// Page-specific container overrides
$walkers_container_bg = getSetting('PAGES.walkers.container_background_color', null);
if ($walkers_container_bg) {
    echo ".walkers-container {\n";
    echo "    background-color: {$walkers_container_bg} !important;\n";
    echo "}\n\n";
}

$principles_container_bg = getSetting('PAGES.principles.container_background_color', null);
if ($principles_container_bg) {
    echo ".principles-bg {\n";
    echo "    background-color: {$principles_container_bg} !important;\n";
    echo "}\n\n";
}

$profile_container_bg = getSetting('PAGES.profile.container_background_color', null);
if ($profile_container_bg) {
    echo ".profile-info-block, .profile-principles-block {\n";
    echo "    background-color: {$profile_container_bg} !important;\n";
    echo "}\n\n";
}

$prescription_container_bg = getSetting('PAGES.prescription.container_background_color', null);
if ($prescription_container_bg) {
    echo ".prescription-content {\n";
    echo "    background-color: {$prescription_container_bg} !important;\n";
    echo "}\n\n";
}

// Page-specific font families
echo "/* Page-specific font families */\n";

$prescription_font = getSetting('PAGES.prescription.font_family', null);
if ($prescription_font) {
    echo ".prescription-page,\n";
    echo ".prescription-page *,\n";
    echo ".prescription-content {\n";
    echo "    font-family: {$prescription_font} !important;\n";
    echo "}\n\n";
}

$signup_font = getSetting('PAGES.signup.font_family', null);
if ($signup_font) {
    echo ".signup-page,\n";
    echo ".signup-page *,\n";
    echo ".auth-box,\n";
    echo ".auth-form input {\n";
    echo "    font-family: {$signup_font} !important;\n";
    echo "}\n\n";
}

$principles_font = getSetting('PAGES.principles.font_family', null);
if ($principles_font) {
    echo ".principles-page,\n";
    echo ".principles-page *,\n";
    echo ".principle-card {\n";
    echo "    font-family: {$principles_font} !important;\n";
    echo "}\n\n";
}

$profile_font = getSetting('PAGES.profile.font_family', null);
if ($profile_font) {
    echo ".profile-page,\n";
    echo ".profile-page * {\n";
    echo "    font-family: {$profile_font} !important;\n";
    echo "}\n\n";
}

$walkers_font = getSetting('PAGES.walkers.font_family', null);
if ($walkers_font) {
    echo ".walkers-page,\n";
    echo ".walkers-page *,\n";
    echo ".walkers-table {\n";
    echo "    font-family: {$walkers_font} !important;\n";
    echo "}\n\n";
}
